/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.wizards;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.jobs.OpenConnectionsRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionJob;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.ConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionParameterPageManager;
import org.apache.directory.studio.connection.ui.ConnectionUIConstants;
import org.apache.directory.studio.connection.ui.wizards.Messages;
import org.apache.directory.studio.connection.ui.wizards.NewConnectionWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewConnectionWizard
extends Wizard
implements INewWizard {
    private NewConnectionWizardPage[] wizardPages;
    private ConnectionParameterPage[] pages;
    private ConnectionFolder selectedConnectionFolder;

    public NewConnectionWizard() {
        this.setWindowTitle(Messages.getString("NewConnectionWizard.NewLdapConnection"));
        this.setNeedsProgressMonitor(true);
    }

    public static String getId() {
        return ConnectionUIConstants.NEW_WIZARD_NEW_CONNECTION;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ConnectionFolder) {
            this.selectedConnectionFolder = (ConnectionFolder)firstElement;
        } else if (firstElement instanceof Connection) {
            Connection connection = (Connection)firstElement;
            this.selectedConnectionFolder = ConnectionCorePlugin.getDefault().getConnectionFolderManager().getParentConnectionFolder(connection);
        }
        if (this.selectedConnectionFolder == null) {
            this.selectedConnectionFolder = ConnectionCorePlugin.getDefault().getConnectionFolderManager().getRootConnectionFolder();
        }
    }

    public void addPages() {
        this.pages = ConnectionParameterPageManager.getConnectionParameterPages();
        this.wizardPages = new NewConnectionWizardPage[this.pages.length];
        int i = 0;
        while (i < this.pages.length) {
            this.wizardPages[i] = new NewConnectionWizardPage(this, this.pages[i]);
            this.addPage((IWizardPage)this.wizardPages[i]);
            this.pages[i].setRunnableContext((IRunnableContext)this.getContainer());
            ++i;
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        NewConnectionWizardPage[] newConnectionWizardPageArray = this.wizardPages;
        int n = this.wizardPages.length;
        int n2 = 0;
        while (n2 < n) {
            NewConnectionWizardPage wizardPage = newConnectionWizardPageArray[n2];
            PlatformUI.getWorkbench().getHelpSystem().setHelp(wizardPage.getControl(), String.valueOf(ConnectionUIConstants.PLUGIN_ID) + "." + "tools_newconnection_wizard");
            ++n2;
        }
    }

    public boolean canFinish() {
        int i = 0;
        while (i < this.pages.length) {
            if (!this.pages[i].isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean performFinish() {
        ConnectionParameter connectionParameter = new ConnectionParameter();
        int i = 0;
        while (i < this.pages.length) {
            this.pages[i].saveParameters(connectionParameter);
            this.pages[i].saveDialogSettings();
            ++i;
        }
        Connection conn = new Connection(connectionParameter);
        ConnectionCorePlugin.getDefault().getConnectionManager().addConnection(conn);
        this.selectedConnectionFolder.addConnectionId(conn.getId());
        new StudioConnectionJob(new StudioConnectionRunnableWithProgress[]{new OpenConnectionsRunnable(conn)}).execute();
        return true;
    }

    public ConnectionParameter getTestConnectionParameters() {
        ConnectionParameter connectionParameter = new ConnectionParameter();
        int i = 0;
        while (i < this.pages.length) {
            this.pages[i].saveParameters(connectionParameter);
            ++i;
        }
        return connectionParameter;
    }
}

