/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity;

import java.security.MessageDigest;
import java.sql.Driver;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.teiid.datatools.connectivity.Activator;
import org.teiid.datatools.connectivity.Messages;
import org.teiid.datatools.connectivity.TeiidJDBCConnection;
import org.teiid.datatools.connectivity.security.impl.EquinoxSecureStorageProvider;
import org.teiid.datatools.connectivity.spi.ISecureStorageProvider;
import org.teiid.designer.runtime.registry.TeiidRuntimeRegistry;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class ConnectivityUtil {
    private static final String TEIID_PROFILE_PROVIDER_ID = "org.teiid.datatools.connectivity.connectionProfile";
    private static final String DRIVER_DEFINITION_ID_KEY = "org.eclipse.datatools.connectivity.driverDefinitionID";
    private static final String TEIID_DRIVER_NAME = "org.teiid.jdbc.TeiidDriver";
    private static final String TEIID_DATABASE_VENDOR_NAME = "Teiid";
    private static final String TEIID_DRIVER_ID_SKELETON = "DriverDefn.org.teiid.MAJOR.MINOR.driver.serverDriverTemplate.Teiid Server JDBC Driver MAJOR.MINOR Default";
    private static final String TEIID_ADHOC_DRIVER_ID_SKELETON = "DriverDefn.org.teiid.MAJOR.MINOR.driver.serverDriverTemplate.Ad-hoc Teiid Server JDBC Driver MAJOR.MINOR Default";
    private static final String TEIID_ADHOC_DRIVER_DEFAULT_NAME = "Ad-hoc Teiid Server JDBC Driver";
    private static final String TEIID_ADHOC_DRIVER_DEFN_TYPE = "org.teiid.runtime.client.driver.serverDriverTemplate";
    public static final String SECURE_STORAGE_BASEKEY = "org.teiid.datatools.connectivity".replace('.', '/');
    public static final String ADMIN_PASSWORD = "admin_password";
    public static final String JDBC_PASSWORD = "jdbc_password";
    public static final String TOKEN_PREFIX = "TOK##!";

    private static String getTeiidDriverDefinitionId(ITeiidServerVersion serverVersion) {
        String driverDefnId = TEIID_DRIVER_ID_SKELETON.replaceAll("MAJOR", serverVersion.getMajor()).replaceAll("MINOR", serverVersion.getMinor());
        DriverInstance driverInstance = DriverManager.getInstance().getDriverInstanceByID(driverDefnId);
        if (driverInstance != null && driverInstance.getTemplate() != null) {
            return driverDefnId;
        }
        DriverInstance[] driverInstanceArray = DriverManager.getInstance().getAllDriverInstances();
        int n = driverInstanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DriverInstance driver = driverInstanceArray[n2];
            String driverClass = driver.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
            if (TEIID_DRIVER_NAME.equals(driverClass) && driver.getTemplate() != null) {
                String dbVersion = driver.getProperty("org.eclipse.datatools.connectivity.db.version");
                TeiidServerVersion driverVersion = new TeiidServerVersion(dbVersion);
                ITeiidServerVersion minDriverVersion = driverVersion.getMinimumVersion();
                ITeiidServerVersion maxDriverVersion = driverVersion.getMaximumVersion();
                if (!serverVersion.isLessThan(minDriverVersion) && !serverVersion.isGreaterThan(maxDriverVersion)) {
                    return driver.getId();
                }
            }
            ++n2;
        }
        return null;
    }

    private static String createTeiidDriverInstance(ITeiidServerVersion serverVersion, String jarList, String driverURL, String username, String passToken) {
        String driverId = TEIID_ADHOC_DRIVER_ID_SKELETON.replaceAll("MAJOR", serverVersion.getMajor()).replaceAll("MINOR", serverVersion.getMinor());
        DriverInstance driverInstance = DriverManager.getInstance().getDriverInstanceByID(driverId);
        if (driverInstance != null && driverInstance.getTemplate() != null) {
            return driverId;
        }
        PropertySetImpl pset = new PropertySetImpl(TEIID_ADHOC_DRIVER_DEFAULT_NAME, driverId);
        Properties baseProperties = new Properties();
        baseProperties.setProperty("org.eclipse.datatools.connectivity.db.driverClass", TEIID_DRIVER_NAME);
        if (driverURL != null) {
            baseProperties.setProperty("org.eclipse.datatools.connectivity.db.URL", driverURL);
        }
        if (username != null) {
            baseProperties.setProperty("org.eclipse.datatools.connectivity.db.username", username);
        }
        if (passToken != null) {
            baseProperties.setProperty("org.eclipse.datatools.connectivity.db.password", passToken);
        }
        baseProperties.setProperty("org.eclipse.datatools.connectivity.db.vendor", TEIID_DATABASE_VENDOR_NAME);
        baseProperties.setProperty("org.eclipse.datatools.connectivity.db.version", serverVersion.toString());
        baseProperties.setProperty("jarList", jarList);
        baseProperties.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", TEIID_ADHOC_DRIVER_DEFN_TYPE);
        baseProperties.setProperty("org.eclipse.datatools.connectivity.drivers.defnDriverClass", TEIID_DRIVER_NAME);
        pset.setBaseProperties(baseProperties);
        DriverManager.getInstance().addDriverInstance((IPropertySet)pset);
        return driverId;
    }

    private static void storeJDBCPassword(String url, String passToken, String password) {
        if (password == null) {
            return;
        }
        String urlStorageKey = passToken == null ? ConnectivityUtil.buildSecureStorageKey(TeiidJDBCConnection.class, url) : ConnectivityUtil.buildSecureStorageKey(TeiidJDBCConnection.class, url, passToken);
        try {
            ConnectivityUtil.getSecureStorageProvider().storeInSecureStorage(urlStorageKey, JDBC_PASSWORD, password);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private static String acquireDriverDefinition(ITeiidServerVersion serverVersion, String driverPath, String connectionURL, String username, String passToken, String password) throws Exception {
        String driverDefinitionId = ConnectivityUtil.getTeiidDriverDefinitionId(serverVersion);
        DriverInstance mDriver = DriverManager.getInstance().getDriverInstanceByID(driverDefinitionId);
        if (mDriver == null) {
            driverDefinitionId = ConnectivityUtil.createTeiidDriverInstance(serverVersion, driverPath, connectionURL, username, passToken);
        } else {
            String jarList = mDriver.getJarList();
            if (jarList != driverPath) {
                mDriver.getPropertySet().getBaseProperties().put("jarList", driverPath);
            }
            if (connectionURL != null) {
                mDriver.getPropertySet().getBaseProperties().put("org.eclipse.datatools.connectivity.db.URL", connectionURL);
            }
            mDriver.getPropertySet().getBaseProperties().put("org.eclipse.datatools.connectivity.db.password", passToken);
        }
        if (driverDefinitionId == null) {
            throw new Exception(Messages.getString(Messages.ConnectivityUtil.noTeiidDriverDefinitionFound, serverVersion));
        }
        ConnectivityUtil.storeJDBCPassword(connectionURL, passToken, password);
        return driverDefinitionId;
    }

    private static Properties createDriverProps(ITeiidServerVersion serverVersion, String driverId, String jarList, String driverURL, String username, String passToken, String vdbName) {
        Properties baseProperties = new Properties();
        baseProperties.setProperty("jarList", jarList);
        baseProperties.setProperty("org.eclipse.datatools.connectivity.db.driverClass", TEIID_DRIVER_NAME);
        if (driverURL != null) {
            baseProperties.setProperty("org.eclipse.datatools.connectivity.db.URL", driverURL);
        }
        if (username != null) {
            baseProperties.setProperty("org.eclipse.datatools.connectivity.db.username", username);
        }
        if (passToken != null) {
            baseProperties.setProperty("org.eclipse.datatools.connectivity.db.password", passToken);
        }
        baseProperties.setProperty("org.eclipse.datatools.connectivity.db.vendor", TEIID_DATABASE_VENDOR_NAME);
        baseProperties.setProperty("org.eclipse.datatools.connectivity.db.version", serverVersion.toString());
        baseProperties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", vdbName);
        baseProperties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(true));
        baseProperties.setProperty(DRIVER_DEFINITION_ID_KEY, driverId);
        return baseProperties;
    }

    public static IConnectionProfile createTransientTeiidProfile(ITeiidServerVersion serverVersion, String driverPath, String connectionURL, String username, String password, String vdbName) throws CoreException {
        ProfileManager pm = ProfileManager.getInstance();
        try {
            String passToken = ConnectivityUtil.generateHashToken(connectionURL, password);
            String driverDefinitionId = ConnectivityUtil.acquireDriverDefinition(serverVersion, driverPath, connectionURL, username, passToken, password);
            return pm.createTransientProfile(TEIID_PROFILE_PROVIDER_ID, ConnectivityUtil.createDriverProps(serverVersion, driverDefinitionId, driverPath, connectionURL, username, passToken, vdbName));
        }
        catch (Exception e) {
            Status status = new Status(4, "org.teiid.datatools.connectivity", 0, Messages.getString(Messages.ConnectivityUtil.errorGettingProfile, new Object[0]), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public static void deleteTransientTeiidProfile(IConnectionProfile profile) {
        ProfileManager.getInstance().deleteTransientProfile(profile);
    }

    public static Properties createVDBTeiidProfileProperties(ITeiidServerVersion serverVersion, String driverPath, String connectionURL, String username, String password, String vdbName, String profileName) throws CoreException {
        try {
            String passToken = ConnectivityUtil.generateHashToken(connectionURL, password);
            String driverDefinitionId = ConnectivityUtil.acquireDriverDefinition(serverVersion, driverPath, connectionURL, username, passToken, password);
            return ConnectivityUtil.createDriverProps(serverVersion, driverDefinitionId, driverPath, connectionURL, username, passToken, vdbName);
        }
        catch (Exception ex) {
            Status status = new Status(4, "org.teiid.datatools.connectivity", 0, Messages.getString(Messages.ConnectivityUtil.errorGettingProfileProperties, new Object[0]), (Throwable)ex);
            throw new CoreException((IStatus)status);
        }
    }

    public static IConnectionProfile createVDBTeiidProfile(ITeiidServerVersion serverVersion, String driverPath, String connectionURL, String username, String password, String vdbName, String profileName) throws CoreException {
        ProfileManager pm = ProfileManager.getInstance();
        try {
            String passToken = ConnectivityUtil.generateHashToken(connectionURL, password);
            String driverDefinitionId = ConnectivityUtil.acquireDriverDefinition(serverVersion, driverPath, connectionURL, username, passToken, password);
            IConnectionProfile existingCP = pm.getProfileByName(profileName);
            if (existingCP != null) {
                return existingCP;
            }
            return pm.createProfile(profileName, "", TEIID_PROFILE_PROVIDER_ID, ConnectivityUtil.createDriverProps(serverVersion, driverDefinitionId, driverPath, connectionURL, username, passToken, vdbName));
        }
        catch (Exception e) {
            Status status = new Status(4, "org.teiid.datatools.connectivity", 0, Messages.getString(Messages.ConnectivityUtil.errorGettingProfile, new Object[0]), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public static String buildSecureStorageKey(Class<?> klazz, String ... args) {
        StringBuilder secureKeyBuilder = new StringBuilder(SECURE_STORAGE_BASEKEY).append('/').append(klazz.getSimpleName()).append('/');
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg != null) {
                    secureKeyBuilder.append(arg).append('/');
                }
                ++n2;
            }
        }
        return secureKeyBuilder.toString();
    }

    public static String generateHashToken(String ... args) throws Exception {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            builder.append(arg);
            builder.append('/');
            ++n2;
        }
        MessageDigest sha = MessageDigest.getInstance("SHA-512");
        sha.update(builder.toString().getBytes("UTF-8"));
        byte[] hashedByteArray = sha.digest();
        return TOKEN_PREFIX + Base64.encodeBase64URLSafeString((byte[])hashedByteArray);
    }

    public static boolean isPasswordToken(String arg) {
        return arg != null && arg.startsWith(TOKEN_PREFIX);
    }

    public static ISecureStorageProvider getSecureStorageProvider() {
        return EquinoxSecureStorageProvider.getInstance();
    }

    public static Driver getTeiidDriver(ITeiidServerVersion teiidServerVersion, String driverClass) throws Exception {
        Driver driver = TeiidRuntimeRegistry.getInstance().getTeiidDriver(teiidServerVersion);
        if (driver != null && driver.getClass().getName().equals(driverClass)) {
            return driver;
        }
        String msg = Messages.getString(Messages.ConnectivityUtil.noTeiidDriverFound, driverClass, teiidServerVersion);
        throw new IllegalStateException(msg);
    }
}

