/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "org.teiid.datatools.connectivity.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.teiid.datatools.connectivity.messages");
    private static final String DOT = ".";

    private static String getEnumName(Enum<?> enumValue) {
        String className = enumValue.getClass().getName();
        String[] components = className.split("\\$");
        return components[components.length - 1];
    }

    private Messages() {
    }

    private static String getString(Enum<?> key) {
        try {
            return RESOURCE_BUNDLE.getString(key.toString());
        }
        catch (Exception err) {
            String msg = err instanceof NullPointerException ? "<No message available>" : (err instanceof MissingResourceException ? "<Missing message for key \"" + key + "\" in: " + BUNDLE_NAME + '>' : err.getLocalizedMessage());
            return msg;
        }
    }

    public static String getString(Enum<?> key, Object ... parameters) {
        String text = Messages.getString(key);
        if (text == null) {
            return String.valueOf('<') + key.toString() + '>';
        }
        if (parameters == null || parameters.length == 0) {
            return text;
        }
        return MessageFormat.format(text, parameters);
    }

    public static enum ConnectivityUtil {
        noTeiidDriverDefinitionFound,
        errorGettingProfile,
        errorGettingProfileProperties,
        noTeiidDriverFound;


        public String toString() {
            return String.valueOf(Messages.getEnumName(this)) + Messages.DOT + this.name();
        }
    }

    public static enum TeiidJDBCConnection {
        noDriverFound,
        invalidUserPassword;


        public String toString() {
            return String.valueOf(Messages.getEnumName(this)) + Messages.DOT + this.name();
        }
    }
}

