/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package org.teiid.designer.metamodels.wsdl.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.teiid.designer.metamodels.wsdl.Attribute;
import org.teiid.designer.metamodels.wsdl.AttributeOwner;
import org.teiid.designer.metamodels.wsdl.Definitions;
import org.teiid.designer.metamodels.wsdl.Documentation;
import org.teiid.designer.metamodels.wsdl.Import;
import org.teiid.designer.metamodels.wsdl.NamespaceDeclaration;
import org.teiid.designer.metamodels.wsdl.NamespaceDeclarationOwner;
import org.teiid.designer.metamodels.wsdl.WsdlPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Import</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.teiid.designer.metamodels.wsdl.impl.ImportImpl#getDocumentation <em>Documentation</em>}</li>
 * <li>{@link org.teiid.designer.metamodels.wsdl.impl.ImportImpl#getDeclaredNamespaces <em>Declared Namespaces</em>}</li>
 * <li>{@link org.teiid.designer.metamodels.wsdl.impl.ImportImpl#getAttributes <em>Attributes</em>}</li>
 * <li>{@link org.teiid.designer.metamodels.wsdl.impl.ImportImpl#getNamespace <em>Namespace</em>}</li>
 * <li>{@link org.teiid.designer.metamodels.wsdl.impl.ImportImpl#getLocation <em>Location</em>}</li>
 * <li>{@link org.teiid.designer.metamodels.wsdl.impl.ImportImpl#getDefinitions <em>Definitions</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 *
 * @since 8.0
 */
public class ImportImpl extends EObjectImpl implements Import {

    /**
     * The cached value of the '{@link #getDocumentation() <em>Documentation</em>}' containment reference. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @see #getDocumentation()
     * @generated
     * @ordered
     */
    protected Documentation documentation = null;

    /**
     * The cached value of the '{@link #getDeclaredNamespaces() <em>Declared Namespaces</em>}' containment reference list. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getDeclaredNamespaces()
     * @generated
     * @ordered
     */
    protected EList declaredNamespaces = null;

    /**
     * The cached value of the '{@link #getAttributes() <em>Attributes</em>}' containment reference list. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @see #getAttributes()
     * @generated
     * @ordered
     */
    protected EList attributes = null;

    /**
     * The default value of the '{@link #getNamespace() <em>Namespace</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     * 
     * @see #getNamespace()
     * @generated
     * @ordered
     */
    protected static final String NAMESPACE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getNamespace() <em>Namespace</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     * 
     * @see #getNamespace()
     * @generated
     * @ordered
     */
    protected String namespace = NAMESPACE_EDEFAULT;

    /**
     * The default value of the '{@link #getLocation() <em>Location</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     * 
     * @see #getLocation()
     * @generated
     * @ordered
     */
    protected static final String LOCATION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getLocation()
     * @generated
     * @ordered
     */
    protected String location = LOCATION_EDEFAULT;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ImportImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return WsdlPackage.eINSTANCE.getImport();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public Documentation getDocumentation() {
        return documentation;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public NotificationChain basicSetDocumentation( Documentation newDocumentation,
                                                    NotificationChain msgs ) {
        Documentation oldDocumentation = documentation;
        documentation = newDocumentation;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, WsdlPackage.IMPORT__DOCUMENTATION,
                                                                   oldDocumentation, newDocumentation);
            if (msgs == null) msgs = notification;
            else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public void setDocumentation( Documentation newDocumentation ) {
        if (newDocumentation != documentation) {
            NotificationChain msgs = null;
            if (documentation != null) msgs = ((InternalEObject)documentation).eInverseRemove(this,
                                                                                              WsdlPackage.DOCUMENTATION__DOCUMENTED,
                                                                                              Documentation.class,
                                                                                              msgs);
            if (newDocumentation != null) msgs = ((InternalEObject)newDocumentation).eInverseAdd(this,
                                                                                                 WsdlPackage.DOCUMENTATION__DOCUMENTED,
                                                                                                 Documentation.class,
                                                                                                 msgs);
            msgs = basicSetDocumentation(newDocumentation, msgs);
            if (msgs != null) msgs.dispatch();
        } else if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET,
                                                                          WsdlPackage.IMPORT__DOCUMENTATION, newDocumentation,
                                                                          newDocumentation));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public EList getDeclaredNamespaces() {
        if (declaredNamespaces == null) {
            declaredNamespaces = new EObjectContainmentWithInverseEList(NamespaceDeclaration.class, this,
                                                                        WsdlPackage.IMPORT__DECLARED_NAMESPACES,
                                                                        WsdlPackage.NAMESPACE_DECLARATION__OWNER);
        }
        return declaredNamespaces;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public EList getAttributes() {
        if (attributes == null) {
            attributes = new EObjectContainmentWithInverseEList(Attribute.class, this, WsdlPackage.IMPORT__ATTRIBUTES,
                                                                WsdlPackage.ATTRIBUTE__ATTRIBUTE_OWNER);
        }
        return attributes;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public String getNamespace() {
        return namespace;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public void setNamespace( String newNamespace ) {
        String oldNamespace = namespace;
        namespace = newNamespace;
        if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET, WsdlPackage.IMPORT__NAMESPACE,
                                                                   oldNamespace, namespace));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public String getLocation() {
        return location;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public void setLocation( String newLocation ) {
        String oldLocation = location;
        location = newLocation;
        if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET, WsdlPackage.IMPORT__LOCATION,
                                                                   oldLocation, location));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public Definitions getDefinitions() {
        if (eContainerFeatureID != WsdlPackage.IMPORT__DEFINITIONS) return null;
        return (Definitions)eContainer;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
	public void setDefinitions( Definitions newDefinitions ) {
        if (newDefinitions != eContainer || (eContainerFeatureID != WsdlPackage.IMPORT__DEFINITIONS && newDefinitions != null)) {
            if (EcoreUtil.isAncestor(this, newDefinitions)) throw new IllegalArgumentException(
                                                                                               "Recursive containment not allowed for " + toString()); //$NON-NLS-1$
            NotificationChain msgs = null;
            if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
            if (newDefinitions != null) msgs = ((InternalEObject)newDefinitions).eInverseAdd(this,
                                                                                             WsdlPackage.DEFINITIONS__IMPORTS,
                                                                                             Definitions.class,
                                                                                             msgs);
            msgs = eBasicSetContainer((InternalEObject)newDefinitions, WsdlPackage.IMPORT__DEFINITIONS, msgs);
            if (msgs != null) msgs.dispatch();
        } else if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET,
                                                                          WsdlPackage.IMPORT__DEFINITIONS, newDefinitions,
                                                                          newDefinitions));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd( InternalEObject otherEnd,
                                          int featureID,
                                          Class baseClass,
                                          NotificationChain msgs ) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case WsdlPackage.IMPORT__DOCUMENTATION:
                    if (documentation != null) msgs = ((InternalEObject)documentation).eInverseRemove(this,
                                                                                                      EOPPOSITE_FEATURE_BASE
                                                                                                      - WsdlPackage.IMPORT__DOCUMENTATION,
                                                                                                      null,
                                                                                                      msgs);
                    return basicSetDocumentation((Documentation)otherEnd, msgs);
                case WsdlPackage.IMPORT__DECLARED_NAMESPACES:
                    return ((InternalEList)getDeclaredNamespaces()).basicAdd(otherEnd, msgs);
                case WsdlPackage.IMPORT__ATTRIBUTES:
                    return ((InternalEList)getAttributes()).basicAdd(otherEnd, msgs);
                case WsdlPackage.IMPORT__DEFINITIONS:
                    if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, WsdlPackage.IMPORT__DEFINITIONS, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove( InternalEObject otherEnd,
                                             int featureID,
                                             Class baseClass,
                                             NotificationChain msgs ) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case WsdlPackage.IMPORT__DOCUMENTATION:
                    return basicSetDocumentation(null, msgs);
                case WsdlPackage.IMPORT__DECLARED_NAMESPACES:
                    return ((InternalEList)getDeclaredNamespaces()).basicRemove(otherEnd, msgs);
                case WsdlPackage.IMPORT__ATTRIBUTES:
                    return ((InternalEList)getAttributes()).basicRemove(otherEnd, msgs);
                case WsdlPackage.IMPORT__DEFINITIONS:
                    return eBasicSetContainer(null, WsdlPackage.IMPORT__DEFINITIONS, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainer( NotificationChain msgs ) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case WsdlPackage.IMPORT__DEFINITIONS:
                    return eContainer.eInverseRemove(this, WsdlPackage.DEFINITIONS__IMPORTS, Definitions.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object eGet( EStructuralFeature eFeature,
                        boolean resolve ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.IMPORT__DOCUMENTATION:
                return getDocumentation();
            case WsdlPackage.IMPORT__DECLARED_NAMESPACES:
                return getDeclaredNamespaces();
            case WsdlPackage.IMPORT__ATTRIBUTES:
                return getAttributes();
            case WsdlPackage.IMPORT__NAMESPACE:
                return getNamespace();
            case WsdlPackage.IMPORT__LOCATION:
                return getLocation();
            case WsdlPackage.IMPORT__DEFINITIONS:
                return getDefinitions();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void eSet( EStructuralFeature eFeature,
                      Object newValue ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.IMPORT__DOCUMENTATION:
                setDocumentation((Documentation)newValue);
                return;
            case WsdlPackage.IMPORT__DECLARED_NAMESPACES:
                getDeclaredNamespaces().clear();
                getDeclaredNamespaces().addAll((Collection)newValue);
                return;
            case WsdlPackage.IMPORT__ATTRIBUTES:
                getAttributes().clear();
                getAttributes().addAll((Collection)newValue);
                return;
            case WsdlPackage.IMPORT__NAMESPACE:
                setNamespace((String)newValue);
                return;
            case WsdlPackage.IMPORT__LOCATION:
                setLocation((String)newValue);
                return;
            case WsdlPackage.IMPORT__DEFINITIONS:
                setDefinitions((Definitions)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void eUnset( EStructuralFeature eFeature ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.IMPORT__DOCUMENTATION:
                setDocumentation((Documentation)null);
                return;
            case WsdlPackage.IMPORT__DECLARED_NAMESPACES:
                getDeclaredNamespaces().clear();
                return;
            case WsdlPackage.IMPORT__ATTRIBUTES:
                getAttributes().clear();
                return;
            case WsdlPackage.IMPORT__NAMESPACE:
                setNamespace(NAMESPACE_EDEFAULT);
                return;
            case WsdlPackage.IMPORT__LOCATION:
                setLocation(LOCATION_EDEFAULT);
                return;
            case WsdlPackage.IMPORT__DEFINITIONS:
                setDefinitions((Definitions)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean eIsSet( EStructuralFeature eFeature ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.IMPORT__DOCUMENTATION:
                return documentation != null;
            case WsdlPackage.IMPORT__DECLARED_NAMESPACES:
                return declaredNamespaces != null && !declaredNamespaces.isEmpty();
            case WsdlPackage.IMPORT__ATTRIBUTES:
                return attributes != null && !attributes.isEmpty();
            case WsdlPackage.IMPORT__NAMESPACE:
                return NAMESPACE_EDEFAULT == null ? namespace != null : !NAMESPACE_EDEFAULT.equals(namespace);
            case WsdlPackage.IMPORT__LOCATION:
                return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
            case WsdlPackage.IMPORT__DEFINITIONS:
                return getDefinitions() != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int eBaseStructuralFeatureID( int derivedFeatureID,
                                         Class baseClass ) {
        if (baseClass == NamespaceDeclarationOwner.class) {
            switch (derivedFeatureID) {
                case WsdlPackage.IMPORT__DECLARED_NAMESPACES:
                    return WsdlPackage.NAMESPACE_DECLARATION_OWNER__DECLARED_NAMESPACES;
                default:
                    return -1;
            }
        }
        if (baseClass == AttributeOwner.class) {
            switch (derivedFeatureID) {
                case WsdlPackage.IMPORT__ATTRIBUTES:
                    return WsdlPackage.ATTRIBUTE_OWNER__ATTRIBUTES;
                default:
                    return -1;
            }
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int eDerivedStructuralFeatureID( int baseFeatureID,
                                            Class baseClass ) {
        if (baseClass == NamespaceDeclarationOwner.class) {
            switch (baseFeatureID) {
                case WsdlPackage.NAMESPACE_DECLARATION_OWNER__DECLARED_NAMESPACES:
                    return WsdlPackage.IMPORT__DECLARED_NAMESPACES;
                default:
                    return -1;
            }
        }
        if (baseClass == AttributeOwner.class) {
            switch (baseFeatureID) {
                case WsdlPackage.ATTRIBUTE_OWNER__ATTRIBUTES:
                    return WsdlPackage.IMPORT__ATTRIBUTES;
                default:
                    return -1;
            }
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (namespace: "); //$NON-NLS-1$
        result.append(namespace);
        result.append(", location: "); //$NON-NLS-1$
        result.append(location);
        result.append(')');
        return result.toString();
    }

} // ImportImpl
