/*******************************************************************************
 * <copyright>
 *
 * Copyright (c) 2005, 2010 SAP AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SAP AG - initial API, implementation and documentation
 *
 * </copyright>
 *
 *******************************************************************************/
package org.switchyard.tools.ui.editor.util;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/**
 * @author bfitzpat
 * 
 */
public final class ExampleUtil {

    private ExampleUtil() {
        // empty
    }

    /**
     * Opens an simple input dialog with OK and Cancel buttons.
     * <p>
     * 
     * @param dialogTitle the dialog title, or <code>null</code> if none
     * @param dialogMessage the dialog message, or <code>null</code> if none
     * @param initialValue the initial input value, or <code>null</code> if none
     *            (equivalent to the empty string)
     * @return the string
     */
    public static String askString(String dialogTitle, String dialogMessage, String initialValue) {
        String ret = null;
        Shell shell = getShell();
        InputDialog inputDialog = new InputDialog(shell, dialogTitle, dialogMessage, initialValue, null);
        int retDialog = inputDialog.open();
        if (retDialog == Window.OK) {
            ret = inputDialog.getValue();
        }
        return ret;
    }

    /**
     * Returns the currently active Shell.
     * 
     * @return The currently active Shell.
     */
    private static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}
