/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;


/**
 * AliasEntryPanel
 *
 * @since 8.0
 */
public class AssociatedLevelsPanel extends Composite {

    private static final int LABEL_GRID_STYLE   = GridData.HORIZONTAL_ALIGN_BEGINNING; 
    private static final String TEXT_1          = DiagramUiConstants.Util.getString("AssociatedLevelsPanel.text_1"); //$NON-NLS-1$
    private static final String TEXT_2          = DiagramUiConstants.Util.getString("AssociatedLevelsPanel.text_2"); //$NON-NLS-1$
    private static final String TEXT_3          = DiagramUiConstants.Util.getString("AssociatedLevelsPanel.text_3"); //$NON-NLS-1$
    private static final String DEFAULT_VALUE   = DiagramUiConstants.Util.getString("AssociatedLevelsPanel.defaultValue"); //$NON-NLS-1$

    private Text levelsText;
    //============================================================
    // Constructors
    //============================================================
    /**
     * Constructor.
     * 
     * @param parent    Parent of this control
     */
    public AssociatedLevelsPanel(Composite parent) {
        super(parent, SWT.NONE);
        init();
    }
    
    //============================================================
    // Instance methods
    //============================================================
    
    /**
     * Initialize the panel.
     */
    private void init( ) {
        //------------------------------        
        // Set layout for the Composite
        //------------------------------        
        GridLayout gridLayout = new GridLayout();
        this.setLayout(gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(GridData.FILL_BOTH);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        
        WidgetFactory.createLabel(this,LABEL_GRID_STYLE,1,TEXT_1);

        Composite levelsPanel = new Composite(this, SWT.NONE);
        GridLayout levelsLayout = new GridLayout();
        levelsPanel.setLayout(levelsLayout);
        levelsLayout.numColumns = 1;

        levelsText = WidgetFactory.createTextField(levelsPanel, GridData.FILL_HORIZONTAL);
        levelsText.setTextLimit(50);
        levelsText.setText(DEFAULT_VALUE);

        GridData levelsTextGridData = new GridData();
        levelsTextGridData.widthHint = 30;
        levelsText.setLayoutData(levelsTextGridData);
        levelsText.selectAll();
        Label textLabel_2 = new Label(levelsPanel, SWT.NONE);
        textLabel_2.setText(TEXT_2); 
        Label textLabel_3 = new Label(levelsPanel, SWT.NONE);
        textLabel_3.setText(TEXT_3); 
    }
    
    public int getLevels() {
        return Integer.parseInt(levelsText.getText()); 
    }

}
