/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package org.teiid.designer.diagram.ui.figure;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;

/**
 * DiagramFigure
 *
 * @since 8.0
 */
public interface DiagramFigure {
    
    DiagramModelNode getDiagramModelNode();
    
    void setDiagramModelNode(DiagramModelNode diagramNode);
    
    void layoutFigure();

    void activate();
    
    void deactivate();

    /**
     * Method providing the EditPart and others, access to the figure to update itself for a size change
     * @param newSize
     */
    void updateForSize(Dimension newSize);
    
    /**
     * Method providing the EditPart and others, access to the figure to update itself for a location change
     * @param newlocation
     */
    void updateForLocation(Point newLocation);
    
    
    /**
     * Method providing the EditPart and others, access to the figure to update itself for a name change
     * @param newName
     */
    void updateForName(String newName);
    
	/**
	 * Method providing the EditPart and others, access to the figure to update itself for a name change
	 * @param newName
	 * @param icon
	 */
	void updateForName(String newName, Image icon);

    
    /**
     * Method providing the EditPart and others, access to the figure to update itself for a font change
     * @param font
     */
    void updateForFont(Font font);

    /**
     * Method to tell the figure to add/or remove error icon decorator
     * @param hasErrors
     */
    void updateForError(boolean hasErrors);
    
    /**
     * Method to tell the figure to add/or remove warning icon decorator
     * @param hasWarnings
     */
    void updateForWarning(boolean hasWarnings);
    
    /**
     * Method to allow a call to figures to generically set a hilite backaground color.
     * In particular, UmlAttributes...
     * @param hiliteColor
     */
    void hiliteBackground(Color hiliteColor);
    
    /**
     * Method to allow a call to figures to generically tell the figure to render itself to a select state.
     * In particular, UmlAttributes...
     * @param hiliteColor
     */
    void showSelected(boolean selected);
    
    /**
     * Simple method designed to allow quick call to the edit part to refresh the "font"
     * of any object.
     *
     */
    void refreshFont();
    
    /**
     * Add an button with image overlay to the figure. This is required to specialize for the Recursive Icon for
     * MappingClasses in XML Document Mappings..
     * @param image
     */
    void addEditButton(Image image);
    
	/**
	 * Add an button with image overlay to the figure.
	 * @param image
	 */
	void addUpperLeftButton(Image image);
    
    /**
     * Add an image overlay to the figure. This is required to specialize for the icons like "locked" for
     * VirtualGroups
     * @param image
     * @param positionIndex - See DiagramUiConstants.Position for valid values.
     */
    void addImage(Image image, int positionIndex);
    
    /**
     * Retrieve the base color pallete for a given figure
     * @return
     */
	ColorPalette getColorPalette();
}
