/******************************************************************************* 
 * Copyright (c) 2009 Red Hat, Inc. 
 * Distributed under license by Red Hat, Inc. All rights reserved. 
 * This program is made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Red Hat, Inc. - initial API and implementation 
 ******************************************************************************/ 
package org.jboss.tools.esb.validator;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.preferences.SeverityPreferences;

/**
 * @author Alexey Kazakov
 */
public class ESBPreferences extends SeverityPreferences {

	public static final Set<String> SEVERITY_OPTION_NAMES = new HashSet<String>();

	private static ESBPreferences INSTANCE = new ESBPreferences();

	//Channel ID ref group
	
	public static final String LISTENER_REFERENCES_NON_EXISTENT_CHANNEL = INSTANCE.createSeverityOption("listenerReferencesNonExistentChannel"); //$NON-NLS-1$
	public static final String LISTENER_REFERENCES_INCOMPATIBLE_CHANNEL = INSTANCE.createSeverityOption("listenerReferencesIncompatibleChannel"); //$NON-NLS-1$

	//Schedule ID ref group
	
	public static final String LISTENER_REFERENCES_NON_EXISTENT_SCHEDULE = INSTANCE.createSeverityOption("listenerReferencesNonExistentSchedule"); //$NON-NLS-1$

	//Actions
	public static final String BUSINESS_RULES_PROCESSOR_PROBLEMS = INSTANCE.createSeverityOption("businessRulesProcessorProblems"); //$NON-NLS-1$

	/**
	 * @return the only instance of CDIPreferences
	 */
	public static ESBPreferences getInstance() {
		return INSTANCE;
	}

	private ESBPreferences() {
	}

	/* (non-Javadoc)
	 * @see org.jboss.tools.common.preferences.SeverityPreferences#createSeverityOption(java.lang.String)
	 */
	@Override
	protected String createSeverityOption(String shortName) {
		String name = getPluginId() + ".validator.problem." + shortName; //$NON-NLS-1$
		SEVERITY_OPTION_NAMES.add(name);
		return name;
	}

	/* (non-Javadoc)
	 * @see org.jboss.tools.common.preferences.SeverityPreferences#getPluginId()
	 */
	@Override
	protected String getPluginId() {
		return ESBValidatorPlugin.PLUGIN_ID;
	}

	/* (non-Javadoc)
	 * @see org.jboss.tools.common.preferences.SeverityPreferences#getSeverityOptionNames()
	 */
	@Override
	protected Set<String> getSeverityOptionNames() {
		return SEVERITY_OPTION_NAMES;
	}

	public static boolean shouldValidateCore(IProject project) {
		return true;
	}

	public static boolean isValidationEnabled(IProject project) {
		return INSTANCE.isEnabled(project);
	}

	public static int getMaxNumberOfProblemMarkersPerFile(IProject project) {
		return INSTANCE.getMaxNumberOfProblemMarkersPerResource(project);
	}
}