/* Generated By:JJTree: Do not edit this line. StoredProcedure.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=true,VISITOR=true,TRACK_TOKENS=false,NODE_PREFIX=,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.designer.query.sql.lang.ISPParameter.ParameterInfo;
import org.teiid.designer.query.sql.lang.IStoredProcedure;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory.ASTNodes;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.runtime.client.Messages;

/**
 *
 */
public class StoredProcedure extends ProcedureContainer
    implements TargetedCommand, IStoredProcedure<SPParameter, Expression, LanguageVisitor> {

    /** Used as parameters */
    private Map<Integer, SPParameter> mapOfParameters = new TreeMap<Integer, SPParameter>();

    /** Used to reference result set parameter if there is any */
    private Integer resultSetParameterKey;

    private boolean isCallableStatement;

    private boolean calledWithReturn;

    //whether parameters should be displayed in traditional indexed
    //manor, or as named parameters
    private boolean displayNamedParameters;

    private boolean isProcedureRelational;

    private String procedureName;

    private String callableName;

    //stored procedure is treated as a group
    private GroupSymbol groupSymbol;

    private Object procedureID;

    private Object modelID;

    /**
     * @param p
     * @param id
     */
    public StoredProcedure(TeiidParser p, int id) {
        super(p, id);
    }

    /**
     * Return type of command.
     * @return TYPE_STORED_PROCEDURE
     */
    @Override
    public int getType() {
        return TYPE_STORED_PROCEDURE;
    }

    /**
     * Get this stored procedure's name
     *
     * @return procedureName the stored procedure's name
     */
     public String getProcedureName(){
         return this.procedureName;
     }

    /**
    * Set this stored procedure's name
    *
    * @param procedureName the stored procedure's name
    */
    @Override
    public void setProcedureName(String procedureName){
        this.procedureName = procedureName;
    }

    @Override
    public void setProcedureID(Object procedureID){
        this.procedureID = procedureID;
    }

    @Override
    public Object getProcedureID(){
        return this.procedureID;
    }

    @Override
    public String getProcedureCallableName(){
        return this.callableName != null?this.callableName:this.procedureName;
    }

    /**
     * @param callableName
     */
    public void setProcedureCallableName(String callableName){
        this.callableName = callableName;
    }

    /**
     * @return is callable statement
     */
    public boolean isCallableStatement() {
        return isCallableStatement;
    }

    /**
     * @param isCallableStatement
     */
    public void setCallableStatement(boolean isCallableStatement) {
        this.isCallableStatement = isCallableStatement;
    }

    private SPParameter getResultSetParameter(){
        if (this.resultSetParameterKey != null){
            return mapOfParameters.get(resultSetParameterKey);
        }
        return null;
    }

    /**
     * @return a List of SPParameter objects for this stored procedure
     */
     public Collection<SPParameter> getParameters(){
         return mapOfParameters.values();
     }

    /**
     * @param index
     *
     * @return parameter at index
     */
    public SPParameter getParameter(int index){
        return mapOfParameters.get(new Integer(index));
    }

    /**
     * @return number of parameters
     */
    public int getParameterCount() {
        return mapOfParameters.size();
    }

    /**
    * Set a stored procedure's parameter
    *
    * @param parameter <code>StoredProcedureParameter</code> the parameter
    * @throws IllegalArgumentException if the parameters (index and parameter)
    *   are invalid.
    */
    @Override
    public void setParameter(SPParameter parameter){
        if(parameter == null){
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0011));
        }

        Integer key = parameter.getIndex();
        if(parameter.getParameterType() == SPParameter.ParameterInfo.RESULT_SET.index()){
            resultSetParameterKey = key;
        }

        mapOfParameters.put(key, parameter);
    }

    /**
     * Clear parameters
     */
    public void clearParameters(){
        this.mapOfParameters.clear();
    }

    /**
     * @param calledWithReturn
     */
    public void setCalledWithReturn(boolean calledWithReturn) {
        this.calledWithReturn = calledWithReturn;
    }

    /**
     * @return called with return flag
     */
    public boolean isCalledWithReturn() {
        return calledWithReturn;
    }

    /**
     * @return the displayNamedParameters
     */
    public boolean isDisplayNamedParameters() {
        return this.displayNamedParameters;
    }

    /**
     * @param displayNamedParameters the displayNamedParameters to set
     */
    @Override
    public void setDisplayNamedParameters(boolean displayNamedParameters) {
        this.displayNamedParameters = displayNamedParameters;
    }

    /**
     * @return the isProcedureRelational
     */
    public boolean isProcedureRelational() {
        return this.isProcedureRelational;
    }

    /**
     * @param isProcedureRelational the isProcedureRelational to set
     */
    public void setProcedureRelational(boolean isProcedureRelational) {
        this.isProcedureRelational = isProcedureRelational;
    }

    @Override
    public boolean returnsResultSet(){
        SPParameter param = getResultSetParameter();
        return param != null && !param.getResultSetColumns().isEmpty();
    }

    /**
     * @return whether this return any parameters
     */
    public boolean returnParameters() {
        return isCallableStatement || !returnsResultSet();
    }

    /**
     * @return group symbol
     */
    public GroupSymbol getGroupSymbol() {
        if(groupSymbol == null) {
            groupSymbol = parser.createASTNode(ASTNodes.GROUP_SYMBOL);
            groupSymbol.setName(getProcedureCallableName());
        }
        return groupSymbol;
    }

    /**
     * @param group
     */
    public void setGroupSymbol(GroupSymbol group){
        this.groupSymbol = group;
    }

    @Override
    public GroupSymbol getGroup() {
        return getGroupSymbol();
    }

    /**
     * @param group
     */
    public void setGroup(GroupSymbol group){
        setGroupSymbol(group);
    }

    @Override
    public String getGroupName() {
        return getGroupSymbol().getName();
    }

    @Override
    public List<ElementSymbol> getResultSetColumns(){
        SPParameter resultSetParameter = getResultSetParameter();
        if(resultSetParameter != null){
            List<ElementSymbol> result = new ArrayList<ElementSymbol>(resultSetParameter.getResultSetColumns().size());
            for (Iterator<ElementSymbol> i = resultSetParameter.getResultSetColumns().iterator(); i.hasNext();) {
                ElementSymbol symbol = i.next().clone();
                symbol.setGroupSymbol(getGroupSymbol());
                result.add(symbol);
            }
            return result;
        }
        return Collections.emptyList();
    }

    /**
     * Get the ordered list of all elements returned by this query.  These elements
     * may be ElementSymbols or ExpressionSymbols but in all cases each represents a
     * single column.
     * @return Ordered list of ElementSymbol
     */
    @Override
    public List getProjectedSymbols(){
        if (!returnParameters()) {
            return getResultSetColumns();
        }
        //add result set columns
        List<ElementSymbol> result = new ArrayList<ElementSymbol>(getResultSetColumns());
        //add out/inout parameter symbols
        for (SPParameter parameter : mapOfParameters.values()) {
            if(parameter.getParameterType() == ParameterInfo.RETURN_VALUE.index()){
                ElementSymbol symbol = parameter.getParameterSymbol();
                symbol.setGroupSymbol(this.getGroupSymbol());
                result.add(0, symbol);
            } else if(parameter.getParameterType() == ParameterInfo.INOUT.index() || parameter.getParameterType() == ParameterInfo.OUT.index()){
                ElementSymbol symbol = parameter.getParameterSymbol();
                symbol.setGroupSymbol(this.getGroupSymbol());
                result.add(symbol);
            }
        }
        return result;
    }

    @Override
    public List<SPParameter> getInputParameters() {
        List<SPParameter> parameters = new ArrayList<SPParameter>(getParameters());
        Iterator<SPParameter> params = parameters.iterator();
        while (params.hasNext()) {
            SPParameter param = params.next();
            if(param.getParameterType() != ParameterInfo.IN.index() && param.getParameterType() != ParameterInfo.INOUT.index()) {
                params.remove();
            }
        }
        return parameters;
    }

    /**
     * @return model id
     */
    public Object getModelID(){
        return modelID;
    }

    /**
     * @param modelID
     */
    public void setModelID(Object modelID){
        this.modelID = modelID;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.calledWithReturn ? 1231 : 1237);
        result = prime * result + (this.displayNamedParameters ? 1231 : 1237);
        result = prime * result + (this.isCallableStatement ? 1231 : 1237);
        result = prime * result + (this.isProcedureRelational ? 1231 : 1237);
        result = prime * result + ((this.mapOfParameters == null) ? 0 : this.mapOfParameters.hashCode());
        result = prime * result + ((this.procedureName == null) ? 0 : this.procedureName.hashCode());
        result = prime * result + ((this.resultSetParameterKey == null) ? 0 : this.resultSetParameterKey.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!super.equals(obj)) return false;
        if (getClass() != obj.getClass()) return false;
        StoredProcedure other = (StoredProcedure)obj;
        if (this.calledWithReturn != other.calledWithReturn) return false;
        if (this.displayNamedParameters != other.displayNamedParameters) return false;
        if (this.isCallableStatement != other.isCallableStatement) return false;
        if (this.isProcedureRelational != other.isProcedureRelational) return false;
        if (this.mapOfParameters == null) {
            if (other.mapOfParameters != null) return false;
        } else if (!this.mapOfParameters.equals(other.mapOfParameters)) return false;
        if (this.procedureName == null) {
            if (other.procedureName != null) return false;
        } else if (!this.procedureName.equals(other.procedureName)) return false;
        if (this.resultSetParameterKey == null) {
            if (other.resultSetParameterKey != null) return false;
        } else if (!this.resultSetParameterKey.equals(other.resultSetParameterKey)) return false;
        return true;
    }

    /** Accept the visitor. **/
    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StoredProcedure clone() {
        StoredProcedure clone = new StoredProcedure(this.parser, this.id);

        if(getProcedureName() != null)
            clone.setProcedureName(getProcedureName());
        clone.setCallableStatement(isCallableStatement());
        
        if(getParameters() != null) {
            for (SPParameter parameter : getParameters()) {
                clone.setParameter(parameter.clone());
            }
        }
        
        clone.setCalledWithReturn(isCalledWithReturn());
        clone.setDisplayNamedParameters(isDisplayNamedParameters());
        clone.setProcedureRelational(isProcedureRelational());
        if(getSourceHint() != null)
            clone.setSourceHint(getSourceHint());
        if(getOption() != null)
            clone.setOption(getOption().clone());

        copyMetadataState(clone);
        return clone;
    }

}
/* JavaCC - OriginalChecksum=c312e9c5d62fcc77b0a38cf092591213 (do not edit this line) */
