/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.soa.sca.core.model.addressing.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.soa.sca.core.model.CoreSCAEditPlugin;
import org.eclipse.soa.sca.core.model.addressing.AddressingPackage;

import org.eclipse.soa.sca.core.model.addressing.util.AddressingAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AddressingItemProviderAdapterFactory extends AddressingAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(CoreSCAEditPlugin.INSTANCE, AddressingPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AddressingItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.AttributedQNameType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributedQNameTypeItemProvider attributedQNameTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.AttributedQNameType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributedQNameTypeAdapter() {
		if (attributedQNameTypeItemProvider == null) {
			attributedQNameTypeItemProvider = new AttributedQNameTypeItemProvider(this);
		}

		return attributedQNameTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.AttributedUnsignedLongType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributedUnsignedLongTypeItemProvider attributedUnsignedLongTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.AttributedUnsignedLongType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributedUnsignedLongTypeAdapter() {
		if (attributedUnsignedLongTypeItemProvider == null) {
			attributedUnsignedLongTypeItemProvider = new AttributedUnsignedLongTypeItemProvider(this);
		}

		return attributedUnsignedLongTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.AttributedURIType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributedURITypeItemProvider attributedURITypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.AttributedURIType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributedURITypeAdapter() {
		if (attributedURITypeItemProvider == null) {
			attributedURITypeItemProvider = new AttributedURITypeItemProvider(this);
		}

		return attributedURITypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.DocumentRoot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentRootItemProvider documentRootItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.DocumentRoot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDocumentRootAdapter() {
		if (documentRootItemProvider == null) {
			documentRootItemProvider = new DocumentRootItemProvider(this);
		}

		return documentRootItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.EndpointReferenceType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EndpointReferenceTypeItemProvider endpointReferenceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.EndpointReferenceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEndpointReferenceTypeAdapter() {
		if (endpointReferenceTypeItemProvider == null) {
			endpointReferenceTypeItemProvider = new EndpointReferenceTypeItemProvider(this);
		}

		return endpointReferenceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.MetadataType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MetadataTypeItemProvider metadataTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.MetadataType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetadataTypeAdapter() {
		if (metadataTypeItemProvider == null) {
			metadataTypeItemProvider = new MetadataTypeItemProvider(this);
		}

		return metadataTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.ProblemActionType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProblemActionTypeItemProvider problemActionTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.ProblemActionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProblemActionTypeAdapter() {
		if (problemActionTypeItemProvider == null) {
			problemActionTypeItemProvider = new ProblemActionTypeItemProvider(this);
		}

		return problemActionTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.ReferenceParametersType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceParametersTypeItemProvider referenceParametersTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.ReferenceParametersType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceParametersTypeAdapter() {
		if (referenceParametersTypeItemProvider == null) {
			referenceParametersTypeItemProvider = new ReferenceParametersTypeItemProvider(this);
		}

		return referenceParametersTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.soa.sca.core.model.addressing.RelatesToType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelatesToTypeItemProvider relatesToTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.soa.sca.core.model.addressing.RelatesToType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelatesToTypeAdapter() {
		if (relatesToTypeItemProvider == null) {
			relatesToTypeItemProvider = new RelatesToTypeItemProvider(this);
		}

		return relatesToTypeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (attributedQNameTypeItemProvider != null) attributedQNameTypeItemProvider.dispose();
		if (attributedUnsignedLongTypeItemProvider != null) attributedUnsignedLongTypeItemProvider.dispose();
		if (attributedURITypeItemProvider != null) attributedURITypeItemProvider.dispose();
		if (documentRootItemProvider != null) documentRootItemProvider.dispose();
		if (endpointReferenceTypeItemProvider != null) endpointReferenceTypeItemProvider.dispose();
		if (metadataTypeItemProvider != null) metadataTypeItemProvider.dispose();
		if (problemActionTypeItemProvider != null) problemActionTypeItemProvider.dispose();
		if (referenceParametersTypeItemProvider != null) referenceParametersTypeItemProvider.dispose();
		if (relatesToTypeItemProvider != null) relatesToTypeItemProvider.dispose();
	}

}
